/******************************************************************************
#ifdef	DOC
  File Name		: adeca_bridge_data_host.h
  Description	:
  Remark		:
  Date			: 2010/11/25
  Copyright		: Panasonic Corporation.
  %Id:
#endif
 *****************************************************************************/
#ifndef _MN2WS0270_ADECA_BRIDGE_DATA_HOST_H_
#define _MN2WS0270_ADECA_BRIDGE_DATA_HOST_H_



/********************************
* Bridge I/F                    *
********************************/

/* event handler table */
typedef struct {
	int	cmd;
	int	(*handler)(int, unsigned int, void *);
} adeca_command_t;



/*******************/
/* API args struct */
/*******************/
/* void struct */
typedef struct {
	int	error;
} adeca_void_arg_t;

typedef adeca_void_arg_t	adeca_init_arg_t;

typedef adeca_void_arg_t	adeca_term_arg_t;

typedef adeca_void_arg_t	adeca_open_arg_t;

typedef adeca_void_arg_t	adeca_close_arg_t;

typedef struct {
	int	error;
	struct {
		ADECA_pid_t		src;
		UH				delay;
	} args;
} adeca_set_spdif_delay_time_arg_t;

typedef struct {
	int	error;
	struct {
		ADECA_pid_t		dst;
		ADECA_pid_t		src;
	} args;
} adeca_select_dspif_input_arg_t;

typedef struct {
	int	error;
	struct {
		ADECA_pid_t		dst;
		ADECA_pid_t		src;
	} args;
} adeca_select_dspif_output_arg_t;

typedef struct {
	int	error;
	struct {
		ADECA_pid_t		dst;
		ADECA_pid_t		src;
	} args;
} adeca_select_adc_port_arg_t;

typedef struct {
	int	error;
	struct {
		ADECA_pid_t		dst;
		ADECA_pid_t		src;
	} args;
} adeca_select_spdif_output_arg_t;


typedef struct {
	int	error;
	struct {
		ADECA_pid_t				dst;
		UH			onoff;
	} args;
} adeca_set_dac_port_power_arg_t;


typedef struct {
	int	error;
	struct {
		ADECA_pid_t					dst;
		ADECA_format_mode_t			mode;
		ADECA_bit_width_t			bit;
	} args;
} adeca_set_chgfmt_output_format_arg_t;

typedef struct {
	int	error;
	struct {
		ADECA_pid_t	       	dst;
		UH	        onoff;
	} args;
} adeca_set_dac_port_mute_arg_t;

typedef adeca_void_arg_t	adeca_start_audio_port_out_arg_t;

typedef struct {
	int	error;
	struct {
		ADECA_pid_t		port;
		UH	onoff;
	} args;
} adeca_set_spdif_mute_arg_t;

typedef struct {
	int	error;
	struct {
		ADECA_pid_t		port;
		UH	onoff;
	} args;
} adeca_set_spdif_arc_mute_arg_t;

typedef struct {
	int	error;
	struct {
		ADECA_select_info_t	info;
	} args;
} adeca_get_sel_info_arg_t;

typedef struct {
	int	error;
	struct {
		ADECA_channel_status_t		stat;
		ADECA_spdif_chstat_bit_t	bit;
	} args;
} adeca_set_spdif_chstat_arg_t;

typedef struct {
	int	error;
	struct {
		ADECA_channel_status_t		stat;
	} args;
} adeca_get_spdif_chstat_arg_t;

typedef struct {
	int	error;
	int	shm_id;
	struct {
		ADECA_pid_t	    dst;
		UW				*buf;
	} args;
} adeca_get_dspif_inbuffer_arg_t;


typedef struct {
	int	error;
	struct {
		ADECA_select_sifinfo_t	info;
	} args;
} adeca_get_sif_info_arg_t;
typedef struct {
	int	error;
	struct {
		ADECA_sif_sys_t		sys;
	} args;
} adeca_set_sif_asd_arg_t;
typedef struct {
	int	error;
	struct {
		ADECA_sif_format_t		format;
	} args;
} adeca_set_sif_format_arg_t;
typedef struct {
	int	error;
	struct {
		ADECA_sif_multiplex_out_t		multiplex;
	} args;
} adeca_set_sif_multiplex_arg_t;
typedef struct {
	int	error;
	struct {
		ADECA_sif_aaos_t	dst;
		UH					high;
		UH					low;
	} args;
} adeca_set_sif_aaos_thresh_arg_t;

typedef struct {
	int error;
	struct {
		ADECA_SPEAKER_t			speaker_select;
	} args;
}adeca_set_input_manage_extin_arg_t;

typedef struct {
	int error;
	struct {
		ADECA_SPEAKER_SELECT_t	speaker_select;
	} args;
}adeca_set_output_manage_aviolib_arg_t;

#endif /* #ifndef _MN2WS0270_ADECA_BRIDGE_DATA_HOST_H_ */
